

varying vec4 color;
varying float NdotL;

flat varying vec3 torch;
varying vec3 viewVector;
varying vec2 lmtexcoord;
float computePhaseFactor(float x, float g)
{
    float gg = g * g;
    return (gg * -0.25 + 0.25) * pow(-2.0 * (g * x) + (gg + 1.0), -1.5) / PI;
}

float gbf(in vec3 eyePlayerPos, in float far)
{
    float distXZ = length((vec3(eyePlayerPos.x, 0.0, eyePlayerPos.z)).xyz);
    float distY = length((vec3(0.0, eyePlayerPos.y, 0.0)).xyz);
    float eyeDist = max(distXZ, distY);

    float borderFogFactor = smoothstep(far, far * 4, eyeDist);
    borderFogFactor *= borderFogFactor;

    return 1 - borderFogFactor;

}

/* DRAWBUFFERS:1*/
void main()
{
    vec3 p3 = toWorldSpace(viewVector);
    float angleFactor = dot(normalize(p3), lightPos);

    float phase0 = computePhaseFactor(angleFactor, 0.75);

    vec4 color = texture(texture, lmtexcoord.xy) * color;
    color.rgb = toLinear(color.rgb) * (sunLight * max(NdotL+phase0, 0.25) + atmosphereUp);
    color.a *= (gbf(p3, far)) * 0.5;
    gl_FragData[0] = color;
}
